// Matteo Lulli, Massimo Bernaschi, Giorgio Parisi 2013
// Physics Dept. 'Sapienza', University of Rome

#include <stdio.h>
#include <math.h>
#include <stdlib.h>

typedef unsigned int RNGT;

#define RANDTWO31M1(seed)\
  RNGT lo = 16807*(seed&0xffff);		\
  RNGT hi = 16807*(seed>>16);			\
  lo += (hi&0x7fff)<<16;			\
  lo += hi>>15;					\
  seed = ((lo&0x80000000)>>31)*(lo-0x7fffffff);	\
  seed += ((lo^0x80000000)>>31)*lo;		\

#define RANDTWO31M1BIS(seed)\
  unsigned long long int swap1 = (16807LL)*seed;\
  seed = (swap1&0x7fffffff) + (swap1>>31);\
  if(seed&0x80000000) seed = (seed&0x7fffffff) + 1;\

#define RANDTWO31M1BIS2(seed)\
  RNGT swap2 = (16807LL)*seed;\
  seed = (swap2&0x7fffffff) + (swap2>>31);\
  if(seed&0x80000000) seed = (seed&0x7fffffff) + 1;\


int main(void){
  //  FILE *urandom = fopen("/dev/urandom", "rb");
  RNGT seed1 = 1, seed3 = 1;

  for(int seed2 = 0x80000000; seed2 <= 0xffffffff; seed2++){
    RNGT seed21 = seed2;
    RNGT seed22 = seed2;

    RANDTWO31M1BIS(seed21);
    RANDTWO31M1(seed22);

    if(seed21 != seed22){
      printf("%u %u %u\n", seed21, seed22, seed2);
      getchar();
    }else seed2 = seed22;
    int k = 0, test = 1;
    for(int i=0; i<0x7fffffff && test; i++){
      RANDTWO31M1BIS(seed1);
      //      RANDTWO31M1(seed3);
      if(seed1 == seed2){
	k++; test = 0;
      }
    }
    printf("%d %u\n", k, seed2);
  }
  return 0;
}
