#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define TWO31M1 0x7fffffff

#define RANDTWO31M1(seed)\
  RNGT lo = 16807*(seed&0xffff);		\
  RNGT hi = 16807*(seed>>16);			\
  lo += (hi&0x7fff)<<16;			\
  lo += hi>>15;					\
  seed = ((lo&0x80000000)>>31)*(lo-0x7fffffff);	\
  seed += ((lo^0x80000000)>>31)*lo;		\

#define RANDTWO31M1BIS(seed)\
  unsigned long long int swap = (16807LL)*seed;\
  seed = (swap&0x7fffffff) + (swap>>31);\
  if(seed&0x80000000) seed = (seed&0x7fffffff) + 1;\

typedef unsigned int RNGT;

int main(void){
  FILE *urandom = fopen("/dev/urandom", "rb");
  RNGT seed = 0;//((0xffffffff<<1)&0x7fffffff);

  while(seed == 0){
    fread(&seed, sizeof(RNGT), 1, urandom);
    seed = seed&TWO31M1;
  }

  fclose(urandom);

  double sum = 0., sum2 = 0.;
  int N = 1000000000;

  for(int i=0; i<N; i++){
    RANDTWO31M1BIS(seed); 
    double swap2 = (((double)seed)/TWO31M1);
    sum += swap2;
    sum2 += swap2*swap2;
  }

  double mean = sum/N, mean2 = sum2/N;

  printf("%21.15e %21.15e\n", mean, sqrt((mean2 - mean*mean)/((double)(N - 1))));

  return 0;
}
