// Matteo Lulli, Massimo Bernaschi, Giorgio Parisi 2013
// Physics Dept. 'Sapienza', University of Rome

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define RED 0
#define BLU 1

typedef struct{
  int x, y, z, zz, k;
}posType;

void myK2Vec(posType *pos, int k, int L, int col){
  int A = L*L;
  pos->k = k;
  pos->x = k%L;
  pos->y = (k/L)%L;
  pos->z = k/A;
  if(col == RED) pos->zz = 2*pos->z;
  else  pos->zz = 2*pos->z + 1;
  return;
}

void realK2Vec(posType *pos, int k, int L, int col){
  int A = L*L;
  pos->k = k;
  pos->x = k%L;
  pos->y = (k/L)%L;
  pos->z = k/A;
  if(col == RED) pos->zz = 2*pos->z;
  else  pos->zz = 2*pos->z + 1;
  return;
}

void my2Real(posType *my, posType *real, int L){
  real->x = my->x;
  real->y = (my->x + my->y)%L;
  real->zz = real->z = (my->y + my->zz)%L;
  
  return;
}

void realVec2K(posType *pos, int L){
  int A = L*L;
  pos->k = (pos->x + pos->y*L + pos->z*A)/2; 
  return;
}

void printPos(posType *pos, FILE *out, char *name){
  fprintf(out, "%s\tk: %2d, {%2d, %2d, %2d} [%2d]\n", 
	  name, pos->k, pos->x, pos->y, pos->zz, pos->z);
  return;
}

void printPos2(posType *pos1, posType *pos2, FILE *out, char *name1, char *name2){
  fprintf(out, "%s\tk: %2d, {%2d, %2d, %2d} [%2d]\t%s\tk: %2d, {%2d, %2d, %2d} [%2d]\n", 
	  name1, pos1->k, pos1->x, pos1->y, pos1->zz, pos1->z,
	  name2, pos2->k, pos2->x, pos2->y, pos2->zz, pos2->z);
  return;
}

int my2RealIndex(int i, int L, int col){
  posType myPos, realPos;
  myK2Vec(&myPos, i, L, col);
  my2Real(&myPos, &realPos, L);
  realVec2K(&realPos, L);
  return realPos.k;
}

int main(int argc, char **argv){
  int L, k;
  if(argc != 3){
    printf("usage: %s <L> <k>\n", argv[0]);
    return 0;
  }
  sscanf(argv[1], "%d", &L);
  sscanf(argv[2], "%d", &k);
  int A = L*L;
  int hL = L/2;

  posType myRed, myBlu, realRed, realBlu;
  myK2Vec(&myRed, k, L, RED);
  myK2Vec(&myBlu, k, L, BLU);
  my2Real(&myRed, &realRed, L);
  my2Real(&myBlu, &realBlu, L);
  realVec2K(&realRed, L);
  realVec2K(&realBlu, L);

  printPos2(&myRed, &realRed, stdout, "RED", "RRED");

  int smzR = k - myRed.z*A + ((myRed.z - 1 + hL)%hL)*A;
  int spzR = k;

  int spyR = smzR - myRed.y*L + ((myRed.y + 1)%L)*L;
  int smyR = spzR - myRed.y*L + ((myRed.y - 1 + L)%L)*L;

  int smxR = spyR - myRed.x + (myRed.x - 1 + L)%L;
  int spxR = smyR - myRed.x + (myRed.x + 1)%L;

  posType mySmzR, realSmzR;
  myK2Vec(&mySmzR, smzR, L, BLU);
  my2Real(&mySmzR, &realSmzR, L);
  realVec2K(&realSmzR, L);
  printPos2(&mySmzR, &realSmzR, stdout, "mySmzR", "reSmzR");
  posType mySpzR, realSpzR;
  myK2Vec(&mySpzR, spzR, L, BLU);
  my2Real(&mySpzR, &realSpzR, L);
  realVec2K(&realSpzR, L);
  printPos2(&mySpzR, &realSpzR, stdout, "mySpzR", "reSpzR");
  posType mySpyR, realSpyR;
  myK2Vec(&mySpyR, spyR, L, BLU);
  my2Real(&mySpyR, &realSpyR, L);
  realVec2K(&realSpyR, L);
  printPos2(&mySpyR, &realSpyR, stdout, "mySpyR", "reSpyR");
  posType mySmyR, realSmyR;
  myK2Vec(&mySmyR, smyR, L, BLU);
  my2Real(&mySmyR, &realSmyR, L);
  realVec2K(&realSmyR, L);
  printPos2(&mySmyR, &realSmyR, stdout, "mySmyR", "reSmyR");
  posType mySmxR, realSmxR;
  myK2Vec(&mySmxR, smxR, L, BLU);
  my2Real(&mySmxR, &realSmxR, L);
  realVec2K(&realSmxR, L);
  printPos2(&mySmxR, &realSmxR, stdout, "mySmxR", "reSmxR");
  posType mySpxR, realSpxR;
  myK2Vec(&mySpxR, spxR, L, BLU);
  my2Real(&mySpxR, &realSpxR, L);
  realVec2K(&realSpxR, L);
  printPos2(&mySpxR, &realSpxR, stdout, "mySpxR", "reSpxR");

  printf("\n\n");
  printPos2(&myBlu, &realBlu, stdout, "BLU", "RBLU");

  int smzB = k;
  int spzB = k - myBlu.z*A + ((myBlu.z - 1 + hL)%hL)*A;

  int spyB = smzB - myBlu.y*L + ((myBlu.y + 1)%L)*L;
  int smyB = spzB - myBlu.y*L + ((myBlu.y - 1 + L)%L)*L;

  int smxB = spyB - myBlu.x + (myBlu.x - 1 + L)%L;
  int spxB = smyB - myBlu.x + (myBlu.x + 1)%L;

  posType mySmzB, realSmzB;
  myK2Vec(&mySmzB, smzB, L, RED);
  my2Real(&mySmzB, &realSmzB, L);
  realVec2K(&realSmzB, L);
  printPos2(&mySmzB, &realSmzB, stdout, "mySmzB", "reSmzB");
  posType mySpzB, realSpzB;
  myK2Vec(&mySpzB, spzB, L, RED);
  my2Real(&mySpzB, &realSpzB, L);
  realVec2K(&realSpzB, L);
  printPos2(&mySpzB, &realSpzB, stdout, "mySpzB", "reSpzB");
  posType mySpyB, realSpyB;
  myK2Vec(&mySpyB, spyB, L, RED);
  my2Real(&mySpyB, &realSpyB, L);
  realVec2K(&realSpyB, L);
  printPos2(&mySpyB, &realSpyB, stdout, "mySpyB", "reSpyB");
  posType mySmyB, realSmyB;
  myK2Vec(&mySmyB, smyB, L, RED);
  my2Real(&mySmyB, &realSmyB, L);
  realVec2K(&realSmyB, L);
  printPos2(&mySmyB, &realSmyB, stdout, "mySmyB", "reSmyB");
  posType mySmxB, realSmxB;
  myK2Vec(&mySmxB, smxB, L, RED);
  my2Real(&mySmxB, &realSmxB, L);
  realVec2K(&realSmxB, L);
  printPos2(&mySmxB, &realSmxB, stdout, "mySmxB", "reSmxB");
  posType mySpxB, realSpxB;
  myK2Vec(&mySpxB, spxB, L, RED);
  my2Real(&mySpxB, &realSpxB, L);
  realVec2K(&realSpxB, L);
  printPos2(&mySpxB, &realSpxB, stdout, "mySpxB", "reSpxB");


  int V = L*L*L;
  int hV = V/2;

  int *realI_R = (int *)malloc(hV*sizeof(int));
  int *realI_B = (int *)malloc(hV*sizeof(int));

  for(int i=0; i<hV; i++){
    realI_R[i] = my2RealIndex(i, L, RED);
    realI_B[i] = my2RealIndex(i, L, BLU);
  }

  int *myI_R = (int *)malloc(hV*sizeof(int));
  int *myI_B = (int *)malloc(hV*sizeof(int));

  for(int i=0; i<hV; i++){
    myI_R[realI_R[i]] = i; 
    myI_B[realI_B[i]] = i; 
  }

  int *myI_R_myI_B = (int *)malloc(hV*sizeof(int));
  int *myI_B_myI_R = (int *)malloc(hV*sizeof(int));

  for(int i=0; i<hV; i++){
    myI_R_myI_B[myI_B[i]] = myI_R[i]; 
    myI_B_myI_R[myI_R[i]] = myI_B[i]; 
  }

  printf("\n\n"); 
  for(int i=0; i<hV; i++) printf("{%d,%d} ", i, realI_R[i]);
  printf("\n\n"); 
  for(int i=0; i<hV; i++) printf("{%d,%d} ", i, realI_B[i]);
  printf("\n\n"); 
  for(int i=0; i<hV; i++) printf("{%d,%d} ", i, myI_R[i]);
  printf("\n\n"); 
  for(int i=0; i<hV; i++) printf("{%d,%d} ", i, myI_B[i]);
  printf("\n\n"); 
  for(int i=0; i<hV; i++) printf("{%d,%d} ", i, myI_R_myI_B[i]);
  printf("\n\n"); 
  for(int i=0; i<hV; i++) printf("{%d,%d} ", i, myI_B_myI_R[i]);
  printf("\n\n"); 

  return 0;
}
