#include <mpi.h>
#include "mpiexch.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

void StartMpi(int *id, int *np, int *argc, char ***argv) {
  int myid, nprocs;
  MPI_Init(argc,argv); /* initialize MPI environment */
  MPI_Comm_rank(MPI_COMM_WORLD, &myid); /* get task number */
  MPI_Comm_size(MPI_COMM_WORLD,&nprocs); /* get number of tasks */
  *id=myid;
  *np=nprocs;
}


struct mpiexch *SetUpMpi(int id, int np, int side) {
  struct mpiexch *p;
  p=(struct mpiexch*)malloc(sizeof(struct mpiexch));
  if(p==NULL) {
    fprintf(stderr,"Could not get memory for mpiexch\n");
    exit(1);
  }
  memset(p,0,sizeof(struct mpiexch));
#if 0
  MY_CUDA_CHECK( cudaMallocHost((void **)&p->redsend,side*side*sizeof(MSC)) );
  MY_CUDA_CHECK( cudaMallocHost((void **)&p->redrecv,side*side*sizeof(MSC)) );
  MY_CUDA_CHECK( cudaMallocHost((void **)&p->bluesend,side*side*sizeof(MSC) );
  MY_CUDA_CHECK( cudaMallocHost((void **)&p->bluerecv,side*side*sizeof(MSC)) );
#endif
  p->blue=id+1<np?id+1:0;
  p->red=id-1<0?np-1:id-1;
  p->nbyte=side*side*sizeof(MSC);
  p->post=FALSE;
  return p;
}

void StopMpi() {
  int rc=MPI_Finalize();
}

#define DIRECTIONS 1
void BlueMpi(struct mpiexch *p) {
            int rc;
            MPI_Status mpi_status[DIRECTIONS];
            static MPI_Request mpireq[DIRECTIONS];
            static int posted=FALSE;
            if(!posted) {
               rc=MPI_Irecv(p->bluerecv, p->nbyte, MPI_BYTE, p->red, BLUETAG,
                           MPI_COMM_WORLD,&mpireq[0]);
               posted=TRUE;
            }
            rc=MPI_Send(p->bluesend, p->nbyte, MPI_BYTE, p->blue, BLUETAG, MPI_COMM_WORLD);

            if(posted) {
              rc=MPI_Waitall(DIRECTIONS,mpireq,mpi_status);
            }
            if(p->post) {
              rc=MPI_Irecv(p->bluerecv, p->nbyte, MPI_BYTE, p->red, BLUETAG,
                         MPI_COMM_WORLD,&mpireq[0]);
              posted=TRUE;
            } else {
              posted=FALSE;
            }
}

void RedMpi(struct mpiexch *p) {
            int rc;
            MPI_Status mpi_status[DIRECTIONS];
            static MPI_Request mpireq[DIRECTIONS];
            static int posted=FALSE;
            if(!posted) {
               rc=MPI_Irecv(p->redrecv, p->nbyte, MPI_BYTE, p->blue, REDTAG,
                           MPI_COMM_WORLD,&mpireq[0]);
               posted=TRUE;
            }
            rc=MPI_Send(p->redsend, p->nbyte, MPI_BYTE, p->red, REDTAG, MPI_COMM_WORLD);

            if(posted) {
              rc=MPI_Waitall(DIRECTIONS,mpireq,mpi_status);
            }
            if(p->post) {
              rc=MPI_Irecv(p->redrecv, p->nbyte, MPI_BYTE, p->blue, REDTAG,
                         MPI_COMM_WORLD,&mpireq[0]);
              posted=TRUE;
            } else {
              posted=FALSE;
            }
}
