// Matteo Lulli, Massimo Bernaschi, Giorgio Parisi 2014
// Physics Dept. 'Sapienza', University of Rome
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <cuda.h>

#include "cudaEA3DMGPU.h"

extern "C" void StartMpi(int *, int *, int *, char ***);
extern "C" void StopMpi(void);
extern "C" struct mpiexch *SetUpMpi(int, int, int);
extern "C" void assignDeviceToProcess(int *);

int main(int argc, char **argv){
  int myrank=0, myid, L;
  L = atoi(argv[1]);
  if(L < 8){
    printf("L:%d?\n", L);
    return 1;
  }
  StartMpi(&myid, &nprocs, &argc, &argv);
  mpiid=myid;
  assignDeviceToProcess(&myrank);
  interexch=SetUpMpi(myid,nprocs,L);
  sysEA3D_t *sys = sysInit(argc, argv);
  if(sys == NULL){
    fprintf(stderr, "\nError sysInit\n");
    return 0;
  } else {
    printf("Init done\n");
  }
  
  if(SimulationFullRecoverTestCongruential(sys)) return 1;

  StopMpi();
  cudaDeviceReset();
  return 0;
}

