// Matteo Lulli, Massimo Bernaschi, Giorgio Parisi 2013
// Physics Dept. 'Sapienza', University of Rome

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "MSC.h"

#define SP(a, m) (a&(~(-(a >= m))))
#define SM(a, m) (a+((-(a < 0))&m))

int main(void){
  int L = 4;
  int A = L*L, V = L*L*L;
  int hL = L/2, hA = A/2, hV = V/2;

  MSC d_sdbLs = findLog2(L*L); 
  MSC d_sdbL = findLog2(L);
  MSC d_sdbLm1 = d_sdbL-1;
  MSC d_sdbLsm1 = d_sdbLs-1;
  MSC d_maskL = (L>>1)-1;
  MSC d_Ldb2 = L>>1;
  MSC d_Lsdb2 = (L*L)>>1;
  MSC d_maskL2 = ((L*L)>>1)-1;
  MSC d_maskL3 = (V>>1)-1;


  for(int k = 0; k<hV; k++){

    int x = k%hL; int y = (k/hL)%L; int z = k/hA;
    int par = (y^z)&1U;
    
    int spxRS = k - x + SP(x + 1 - (par^1U), hL);
    int smxRS = k - x + SM(x - 1 + par, hL);
    int spyRS = k - y*hL + SP(y + 1, L)*hL;
    int smyRS = k - y*hL + SM(y - 1, L)*hL;
    int spzRS = k - z*hA + SP(z + 1, L)*hA;
    int smzRS = k - z*hA + SM(z - 1, L)*hA;

    int spxBS = k - x + SP((x + 1 - par), hL);
    int smxBS = k - x + SM((x - 1 + (par^1U)), hL);
    int spyBS = k - y*hL + SP(y + 1, L)*hL;
    int smyBS = k - y*hL + SM(y - 1, L)*hL;
    int spzBS = k - z*hA + SP(z + 1, L)*hA;
    int smzBS = k - z*hA + SM(z - 1, L)*hA;


    unsigned int iz=k>>d_sdbLsm1;
    unsigned int iy=(k - (iz<<d_sdbLsm1))>>d_sdbLm1;
    int diff=(iz&1)^(iy&1);
    
    int spxRB=(k >> (-diff)) + (((k-(k&d_maskL)) + ((k+1)&d_maskL)) >> (diff-1));
    int smxRB=(((k-(k&d_maskL)) + ((k-1)&d_maskL)) >> (-diff)) + (k>>(diff-1));
    int spyRB=(k-(k&d_maskL2))+((k+d_Ldb2)&d_maskL2);
    int smyRB=(k-(k&d_maskL2))+((k-d_Ldb2)&d_maskL2);
    int spzRB=((k+d_Lsdb2) & d_maskL3);
    int smzRB=((k-d_Lsdb2) & d_maskL3);

    int spxBB=(k >> (diff-1)) + (((k-(k&d_maskL)) + ((k+1)&d_maskL)) >> (-diff));
    int smxBB=(((k-(k&d_maskL)) + ((k-1)&d_maskL)) >> (diff-1)) + (k>>(-diff));
    int spyBB=(k-(k&d_maskL2))+((k+d_Ldb2)&d_maskL2);
    int smyBB=(k-(k&d_maskL2))+((k-d_Ldb2)&d_maskL2);
    int spzBB=((k+d_Lsdb2) & d_maskL3);
    int smzBB=((k-d_Lsdb2) & d_maskL3);

    int mah = x - 1 + (par^1U);

    printf("REDS  : {x:%d y:%d z:%d} k:%d spxST:%d spxBI:%d smxST:%d smxBI:%d\n", 
	   x, y, z, k, spxRS, spxRB, smxRS, smxRB);
    printf("BLUES : {x:%d y:%d z:%d} k:%d spxST:%d spxBI:%d smxST:%d smxBI:%d\n", 
	   x, y, z, k, spxBS, spxBB, smxBS, smxBB);
    printf("%d %d %d %d %d\n", 
	   (x - 1 + (par^1U)), SM(x - 1 + (par^1U), hL), (x - 1 + (par^1U) + hL)%hL,
	   (mah < 0), ((x - 1 + (par^1)) < 0));
    //#define SM(a, m) (a+((-(a < 0))&m))
    printf("\n");

    getchar();
  }

  return 0;
}
